<?php

use Illuminate\Support\Facades\Route;

Route::domain('{subdomain}.'.config('app.hostname'))->group(function () {

    //Customer
    Route::group([], function(){
        Route::get('/', [App\Http\Controllers\CUS\PagesController::class, 'index']);

    });

    //Canteen
    Route::prefix('app')->name('app.')->group(function(){

        Route::middleware(['guest'])->group(function(){

            //Auth
            Route::get('/login', [App\Http\Controllers\CANTEEN\AuthController::class, 'loginForm']);
            Route::post('/login', [App\Http\Controllers\CANTEEN\AuthController::class, 'loginPost']);

            //Rest Password
            Route::get('/forgot-password', [App\Http\Controllers\CANTEEN\ForgotPasswordController::class, 'showForgetPasswordForm']);
            Route::post('/forgot-password', [App\Http\Controllers\CANTEEN\ForgotPasswordController::class, 'submitForgetPasswordForm']); 
            Route::get('/reset-password/{token}', [App\Http\Controllers\CANTEEN\ForgotPasswordController::class, 'showResetPasswordForm']);
            Route::post('/reset-password', [App\Http\Controllers\CANTEEN\ForgotPasswordController::class, 'submitResetPasswordForm']);

        });

        //App
        Route::middleware(['auth'])->group(function(){
            //Logout
            Route::post('/logout', [App\Http\Controllers\CANTEEN\AuthController::class, 'logout']);

            //Index or Dashboard
            Route::get('/', [App\Http\Controllers\CANTEEN\PagesController::class, 'index']);

            //Taxes
            Route::resource('/taxes', App\Http\Controllers\CANTEEN\TaxController::class);
            Route::get('/taxes/{id}/delete', [App\Http\Controllers\CANTEEN\TaxController::class, 'beforeDelete']);

            //Categories
            Route::resource('/categories', App\Http\Controllers\CANTEEN\CategoryController::class);
            Route::get('/categories/{id}/delete', [App\Http\Controllers\CANTEEN\CategoryController::class, 'beforeDelete']);

            //Units
            Route::resource('/units', App\Http\Controllers\CANTEEN\UnitController::class);
            Route::get('/units/{id}/delete', [App\Http\Controllers\CANTEEN\UnitController::class, 'beforeDelete']);

            //Item Badges
            Route::resource('/item-badges', App\Http\Controllers\CANTEEN\ItemBadgeController::class);
            Route::get('/item-badges/{id}/delete', [App\Http\Controllers\CANTEEN\ItemBadgeController::class, 'beforeDelete']);

            //Items
            Route::resource('/items', App\Http\Controllers\CANTEEN\ItemController::class);
            Route::get('/items/{id}/delete', [App\Http\Controllers\CANTEEN\ItemController::class, 'beforeDelete']);

            //Customers
            Route::resource('/customers', App\Http\Controllers\CANTEEN\CustomerController::class);
            Route::get('/customers/{id}/delete', [App\Http\Controllers\CANTEEN\CustomerController::class, 'beforeDelete']);

            //Tables
            Route::resource('/tables', App\Http\Controllers\CANTEEN\TableController::class);
            Route::get('/tables/{id}/delete', [App\Http\Controllers\CANTEEN\TableController::class, 'beforeDelete']);

            //Employee
            Route::resource('/employees', App\Http\Controllers\CANTEEN\EmployeeController::class);
            Route::get('/employees/{id}/delete', [App\Http\Controllers\CANTEEN\EmployeeController::class, 'beforeDelete']);

            //Web - Offers
            Route::resource('/web/offers', App\Http\Controllers\CANTEEN\EmployeeController::class);
            Route::get('/web/offers/{id}/delete', [App\Http\Controllers\CANTEEN\EmployeeController::class, 'beforeDelete']);

            //Web - SEO Settings
            Route::get('/web/seo-setting', [App\Http\Controllers\CANTEEN\WebsiteSettingsController::class, 'seoSetting']);
            Route::post('/web/seo-setting', [App\Http\Controllers\CANTEEN\WebsiteSettingsController::class, 'seoSettingUpdate']);

            //Web - General Settings
            Route::get('/web/general-setting', [App\Http\Controllers\CANTEEN\WebsiteSettingsController::class, 'generalSetting']);
            Route::post('/web/general-setting', [App\Http\Controllers\CANTEEN\WebsiteSettingsController::class, 'generalSettingUpdate']);
            
            //Profile
            Route::get('/my-account', [App\Http\Controllers\CANTEEN\ProfileController::class, 'myAccountForm']);
            Route::post('/my-account', [App\Http\Controllers\CANTEEN\ProfileController::class, 'myAccountUpdate']);

            //Business / Admin Settings
            Route::get('/business-settings', [App\Http\Controllers\CANTEEN\ProfileController::class, 'businessSettingForm']);
            Route::post('/business-settings', [App\Http\Controllers\CANTEEN\ProfileController::class, 'businessSetting']);
            Route::post('/change-password', [App\Http\Controllers\CANTEEN\ProfileController::class, 'changePassword']);

            //POS
            Route::get('/pos', [App\Http\Controllers\CANTEEN\POSController::class, 'index']);
            Route::post('/pos/create-order', [App\Http\Controllers\CANTEEN\POSController::class, 'orderStore']);

            //Payment Transections
            Route::get('/cash-transactions', [App\Http\Controllers\CANTEEN\PaymentTransactionController::class, 'cashTransactions']);
            Route::get('/qrcode-transactions', [App\Http\Controllers\CANTEEN\PaymentTransactionController::class, 'qrcodeTransactions']);
            Route::get('/online-transactions', [App\Http\Controllers\CANTEEN\PaymentTransactionController::class, 'onlineTransactions']);

            //Orders
            Route::get('/orders', [App\Http\Controllers\CANTEEN\OrderController::class, 'index']);
            Route::get('/order-receipt/{id}', [App\Http\Controllers\CANTEEN\OrderController::class, 'orderReceipt']);
            Route::get('/orders/{id}/edit', [App\Http\Controllers\CANTEEN\OrderController::class, 'edit']);
            Route::put('/orders/{id}', [App\Http\Controllers\CANTEEN\OrderController::class, 'update']);

            //Orders
            Route::get('/membership-plans', [App\Http\Controllers\CANTEEN\MembershipPlanController::class, 'index']);
            Route::get('/membership-plans-purchase/{planId}', [App\Http\Controllers\CANTEEN\MembershipPlanController::class, 'planPurchase']);
            
            //Ajax URLs
            Route::get('/ajax/items/add-variant-row', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'addVariantRow']);
            Route::get('/ajax/items/add-addon-row', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'addAddonRow']);
            Route::post('/ajax/pos/add-customer', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'createCustomer']);
            Route::get('/ajax/pos/addons-html/{itemId}', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'addonsHtml']);
            Route::post('/ajax/pos/cart-addons-html', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'cartAddonsHtml']);
            Route::get('/ajax/pos/item-popup/{itemId}', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'cartItemPopUp']);
            Route::get('/ajax/users/permissions/{id}', [App\Http\Controllers\CANTEEN\AjaxResponseController::class, 'userPermissions']);
            
            //Permission
            Route::get('/permissions', [App\Http\Controllers\CANTEEN\PermissionController::class, 'index']);
            Route::post('/permissions/sync', [App\Http\Controllers\CANTEEN\PermissionController::class, 'syncPermission']);
            
            //FCM Notifications
            Route::post('/save-fcm-token', [App\Http\Controllers\CANTEEN\FCMNotificationController::class, 'saveFCMToken']);

        });

    });



});


Route::middleware([])->group(function(){

    Route::get('/', [App\Http\Controllers\CUS\PagesController::class, 'index']);
    Route::get('/test', [App\Http\Controllers\CUS\TestController::class, 'index']);

});

