@extends('canteen.layouts.app')

@section('page-title')
Account Settings
@endsection

@section('page.content')

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <div class="col">
                        <h2 class="page-title">
                            Account Settings
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

			<div class="card">
				<div class="row g-0">
					<div class="col-12 col-md-3 border-end">
                        @include('canteen.pages.profile.sidenav')
					</div>
					<div class="col-12 col-md-9 d-flex flex-column">
                        <form action="{{ url('/app/my-account') }}" method="post" class="card" enctype="multipart/form-data" id="form">
                            @method('POST') @csrf

                            <div class="card-body">
                                <div class="card-status-top bg-light"></div>
                                <h3 class="card-title">Profile Details</h3>
    
                                <div class="mb-3">
                                    <label class="form-label required">Name</label>
                                    <div>
                                        <input type="text" name="name" class="form-control" aria-describedby="name" value="{{ $user->name }}" placeholder="Name">
                                        <div class="invalid-feedback name_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Email</label>
                                    <div>
                                        <input type="text" name="email" class="form-control" aria-describedby="email" value="{{ $user->email }}" placeholder="Email Address">
                                        <div class="invalid-feedback email_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Mobile Number</label>
                                    <div>
                                        <input type="hidden" name="mobile_code" id="mobile_code">
                                        <input type="text" id="mobile_number" name="mobile_number" class="form-control" aria-describedby="mobile_number" value="{{ $user->mobile_number }}" placeholder="Mobile Number">
                                        <div class="invalid-feedback mobile_number_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Address</label>
                                    <div>
                                        <input type="text" name="address" class="form-control" aria-describedby="address" value="{{ $user->address }}" placeholder="e.g. 365/11, West Kafrul, Anwara Hostel, Dhaka 1207">
                                        <div class="invalid-feedback address_error"></div>
                                    </div>
                                </div>
    
                                <div>
                                    <label class="form-label">Password</label>
                                    <a href="#" class="btn btn-1" data-bs-toggle="modal" data-bs-target="#adminPassword">
                                        Change password
                                    </a>
                                </div>
                            </div>

                            <div class="card-footer text-end">
                                <div class="d-flex">
                                    <a href="{{ url('/app') }}" class="btn btn-link">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 14l-4 -4l4 -4" /><path d="M5 10h11a4 4 0 1 1 0 8h-1" /></svg>
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary ms-auto">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                                        Save
                                    </button>
                                </div>
                            </div>
                        </form>
					</div>
				</div>
			</div>

        </div>
    </div>

@endsection

@section('page-modal')
<div class="modal modal-blur fade" id="adminPassword" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-1 modal-dialog-centered" role="document">
		<div class="modal-content">
            <form action="{{ url('/app/change-password') }}" id="changePasswordForm">
                @method('POST') @csrf

                <div class="modal-header">
                    <h5 class="modal-title">Change Admin Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="mb-2">
                        <label class="form-label">Current Password</label>
                        <div class="input-group input-group-flat">
                            <input type="password" name="current_password" class="form-control" placeholder="Current password" autocomplete="off">
                            <span class="input-group-text">
                                <a href="#" class="link-secondary password_toggle" title="Show password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon d-none password_show" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-off password_hide" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.585 10.587a2 2 0 0 0 2.829 2.828" /><path d="M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87" /><path d="M3 3l18 18" /></svg>
                                </a>
                            </span>
                        </div>
                        <div class="invalid-feedback current_password_error"></div>
                    </div>

                    <div class="mb-2">
                        <label class="form-label">New Password</label>
                        <div class="input-group input-group-flat">
                            <input type="password" name="new_password" class="form-control pr-password" placeholder="New password" autocomplete="off">
                            <span class="input-group-text">
                                <a href="#" class="link-secondary password_toggle" title="Show password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon d-none password_show" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-off password_hide" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.585 10.587a2 2 0 0 0 2.829 2.828" /><path d="M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87" /><path d="M3 3l18 18" /></svg>
                                </a>
                            </span>
                        </div>
                        <div class="invalid-feedback new_password_error"></div>
                    </div>

                    <div class="mb-2">
                        <label class="form-label">Confirm New Password</label>
                        <div class="input-group input-group-flat">
                            <input type="password" name="new_password_confirmation" class="form-control" placeholder="Confirm new password" autocomplete="off">
                            <span class="input-group-text">
                                <a href="#" class="link-secondary password_toggle" title="Show password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon d-none password_show" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-off password_hide" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.585 10.587a2 2 0 0 0 2.829 2.828" /><path d="M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87" /><path d="M3 3l18 18" /></svg>
                                </a>
                            </span>
                        </div>
                        <div class="invalid-feedback new_password_confirmation_error"></div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">
                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                        Save
                    </button>
                </div>

            </form>
		</div>
	</div>
</div>
@endsection

@section("page.js")
<script>

    $("#form").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#form')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    window.location.href = data.redirect_url;
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

    $("#changePasswordForm").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#changePasswordForm')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    $("#adminPassword").modal('hide');
                    $("#changePasswordForm")[0].reset();
                    Notiflix.Notify.success(data.message);
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

</script>
@endsection