@extends('canteen.layouts.app')

@section('page-title')
    Cash Transactions
@endsection

@section('page.content')

    <!-- Page header -->
    <form action="">
        <div class="page-header">
            <div class="container-xl">

                <div class="row align-items-center mw-100">
                    <div class="col">
                        <h2 class="page-title">
                            Cash Transactions
                        </h2>
                    </div>
                    <div class="col-auto">
                        <div class="d-flex">
                            <div class="me-3">                            
                                <div class="input-group">
                                    <input type="text" name="query" class="form-control" placeholder="Search..." value="{{ request()->query('query') }}">
                                    <button class="btn" type="submit">
                                        <svg class="me-0" xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-search" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"></path>
                                            <path d="M21 21l-6 -6"></path>
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <a href="{{ request()->fullUrlWithQuery(['export' => 'export']) }}" class="btn btn-secondary">
                                <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-file-type-xls"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M14 3v4a1 1 0 0 0 1 1h4" /><path d="M5 12v-7a2 2 0 0 1 2 -2h7l5 5v4" /><path d="M4 15l4 6" /><path d="M4 21l4 -6" /><path d="M17 20.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75" /><path d="M11 15v6h3" /></svg>
                                Export
                            </a>
                        </div>
                    </div>
                </div>

                <hr class="my-3">
                <div class="row align-items-center justify-content-center">

                    <div class="col-12 col-md-auto d-flex justify-content-between">
                        <h3 class="card-title m-0 mb-1 p-2">
                            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-filter"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 4h16v2.172a2 2 0 0 1 -.586 1.414l-4.414 4.414v7l-6 2v-8.5l-4.48 -4.928a2 2 0 0 1 -.52 -1.345v-2.227z" /></svg>
                            Filters
                        </h3>

                        <div class="clear-filter-div">
                            <a href="{{ url()->current() }}" class="btn btn-md" data-bs-toggle="tooltip" title="Clear Filter & Search">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon text-danger">
                                <path d="M18 6l-12 12"></path>
                                <path d="M6 6l12 12"></path>
                                </svg>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="input-group mb-1">
                            <span class="input-group-text">Accepted By</span>
                            <select name="payment_accepted_by" class="form-control" id="payment_accepted_by" onchange="this.form.submit()">
                                <option value="">All</option>
                                @foreach ($filter_users as $filter_user)
                                    <option value="{{ $filter_user->id }}" {{ request()->query('payment_accepted_by') == $filter_user->id ? 'selected' : '' }}>{{ $filter_user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="input-group mb-1">
                            <span class="input-group-text">From</span>
                            <input type="date" id="from" name="from" class="form-control" placeholder="From Date" value="{{ request()->query('from') }}" onchange="this.form.submit()">
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="input-group mb-1">
                            <span class="input-group-text">To</span>
                            <input type="date" id="to" name="to" class="form-control" placeholder="To Date" value="{{ request()->query('to') }}" onchange="this.form.submit()">
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </form>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">
                                                
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table table-striped">
                                <thead>
                                    <tr>
                                        <th class="w-1">@sortablelink('uid', 'ID.')</th>
                                        <th>@sortablelink('order.uid', 'Order ID')</th>
                                        <th>@sortablelink('accepted_by.name', 'Accepted By')</th>
                                        <th>@sortablelink('amount', 'Amount')</th>
                                        <th>@sortablelink('status', 'Status')</th>
                                        <th>@sortablelink('created_at', 'Payment At')</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @if ($rows->total() === 0)
                                        <tr>
                                            <td class="text-center" colspan="21">No records available to display.</td>
                                        </tr>
                                    @endif

                                    @foreach ($rows as $row)
                                        <tr>
                                            <td>
                                                <span class="text-secondary">{{ $row->uid }}</span>
                                            </td>
                                            <td>{{ $row->order->uid }}</td>
                                            <td>{{ isset($row->accepted_by->name) ? $row->accepted_by->name : '' }}</td>
                                            <td>{{ $row->currency }} {{ $row->amount }}</td>
                                            <td>{{ ucfirst($row->status) }}</td>
                                            <td>{{ date_format($row->created_at, setting('date_time_format')) }}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        
                        {{ $rows->appends(request()->except('page'))->links() }}

                    </div>
                </div>
            </div>
            
        </div>
    </div>


@endsection

