@extends('canteen.layouts.app')

@section('page-title')
Account Settings
@endsection

@section('page.content')

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <div class="col">
                        <h2 class="page-title">
                            Account Settings
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

			<div class="card">
				<div class="row g-0">
					<div class="col-12 col-md-3 border-end">
                        @include('canteen.pages.profile.sidenav')
					</div>
                    
					<div class="col-12 col-md-9 d-flex flex-column px-2">

                        <div class="row justify-content-center mt-4">
                            <div class="col-md-12 col-xl-6">
                                <a class="card card-link mx-2" href="#">
                                    <div class="card-body">
                                        <div class="row">
                                    <div class="col-auto">
                                    <span class="avatar bg-lime text-lime-fg">MS</span>
                                    </div>
                                            <div class="col">
                                                <div class="font-weight-medium">Current plan</div>
                                                <div class="text-secondary">{{ $membership_subscription->name }}</div>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium">Started</div>
                                                <div class="text-secondary">{{ date_format($membership_subscription->start_date, setting('date_format')) }}</div>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium">Expires</div>
                                                <div class="text-secondary">{{ date_format($membership_subscription->end_date, setting('date_format')) }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            
                        </div>

                        <div class="row justify-content-center my-2 mt-4">



                            <div class="col-sm-6 col-lg-4">
                                <div class="card card-md">
                                    <div class="card-body">
                                        <div class="text-uppercase text-secondary font-weight-medium">Monthly</div>
                                        <div class="display-5 fw-bold my-3">&#2547;350</div>
                                        <ul class="list-unstyled lh-lg">
                                            <li>What’s Included</li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                POS Access
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Order Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Table Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Customer Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Menu Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Report and Analytics
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Employee Access
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Accept Online Payment
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Custom Subdomain
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Online Orders
                                            </li>
                                        </ul>
                                        <div class="text-center mt-4">
                                            <a href="{{ url('/app/membership-plans-purchase/1') }}" class="btn w-100">Choose plan</a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-lg-4">
                                <div class="card card-md">
                                    <div class="card-body">
                                        <div class="text-uppercase text-secondary font-weight-medium">Quarterly</div>
                                        <div class="display-5 fw-bold my-3">&#2547;1800</div>
                                        <ul class="list-unstyled lh-lg">
                                            <li>What’s Included</li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                POS Access
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Order Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Table Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Customer Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Menu Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Report and Analytics
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Employee Access
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Accept Online Payment
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Custom Subdomain
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Online Orders
                                            </li>
                                        </ul>
                                        <div class="text-center mt-4">
                                            <a href="{{ url('/app/membership-plans-purchase/2') }}" class="btn w-100">Choose plan</a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-lg-4">

                                <div class="card card-md">
                                    <div class="ribbon ribbon-top ribbon-bookmark bg-green">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-3"><path d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" /></svg>
                                    </div>

                                    <div class="card-body">
                                        <div class="text-uppercase text-secondary font-weight-medium">Annually</div>
                                        <div class="display-5 fw-bold my-3">&#2547;3000</div>
                                        <ul class="list-unstyled lh-lg">
                                            <li>What’s Included</li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                POS Access
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Order Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Table Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Customer Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Menu Management
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Report and Analytics
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Employee Access
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Accept Online Payment
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Custom Subdomain
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon me-1 text-success icon-2"><path d="M5 12l5 5l10 -10" /></svg>
                                                Online Orders
                                            </li>
                                        </ul>
                                        <div class="text-center mt-4">
                                            <a href="{{ url('/app/membership-plans-purchase/3') }}" class="btn btn-green w-100">Choose plan</a>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
					</div>
				</div>
			</div>

        </div>
    </div>


@endsection

@section("page.js")
<script>

    $("#form").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#form')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    window.location.href = data.redirect_url;
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

</script>
@endsection