@extends('canteen.layouts.app')

@section('page-title')
    Items
@endsection

@section('page.content')

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <h2 class="page-title">
                        Items
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex">
                        <div class="me-3 d-none d-md-block">
                            <form action="">
                                <div class="input-group">
                                    <input type="text" name="query" class="form-control" placeholder="Search..." value="{{ request()->query('query') }}">
                                    <button class="btn" type="submit">
                                        <svg class="me-0" xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-search" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"></path>
                                            <path d="M21 21l-6 -6"></path>
                                        </svg>
                                    </button>
                                </div>
                            </form>
                        </div>

                        @can('items.create')
                        <a href="{{ url('/app/items/create') }}" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-plus" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M12 5l0 14"></path>
                                <path d="M5 12l14 0"></path>
                            </svg>
                            Add New
                        </a>
                        @endcan

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">
                
                        <div class="table-responsive min-h-500">
                            <table class="table card-table table-vcenter text-nowrap">
                                <thead>
                                    <tr>
                                        <th class="w-1">@sortablelink('uid', 'ID.')</th>
                                        <th>Image</th>
                                        <th>@sortablelink('has_variant', 'Item Type')</th>
                                        <th>@sortablelink('name', 'Name')</th>
                                        <th>@sortablelink('price', 'Price')</th>
                                        <th>@sortablelink('stock_quantity', 'Stock QTY')</th>
                                        <th>@sortablelink('position', 'Position')</th>
                                        <th>@sortablelink('is_active', 'Status')</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @if ($rows->total() === 0)
                                        <tr>
                                            <td class="text-center" colspan="21">No records available to display.</td>
                                        </tr>
                                    @endif

                                    @foreach ($rows as $row)
                                        <tr>
                                            <td>
                                                <span class="text-secondary">{{ $row->uid }}</span>
                                            </td>
                                            <td>
                                                @if (!empty($row->image) && file_exists(public_path($row->image)))
                                                    <span class="avatar avatar-2" style="background-image: url({{ asset($row->image) }})"></span>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($row->has_variant)
                                                    <span class="badge bg-purple-lt">Variant</span>
                                                @else
                                                    <span class="badge bg-teal-lt">Non Variant</span>
                                                @endif
                                            </td>
                                            <td>{{ $row->name }}</td>
                                            <td>
                                                @if ($row->has_variant)
                                                    <span class="badge bg-light text-light-fg">Not Applicable</span>
                                                @else
                                                    {{ $row->currency }} {{ $row->price }}
                                                @endif
                                            </td>
                                            <td>
                                                @if ($row->has_variant)
                                                    <span class="badge bg-light text-light-fg">Not Applicable</span>
                                                @else
                                                    @if ($row->stock_quantity === NULL)
                                                        <span class="badge bg-yellow text-yellow-fg">Unlimited</span>
                                                    @else
                                                        {{ $row->stock_quantity }}
                                                    @endif
                                                @endif
                                            </td>
                                            <td>{{ $row->position }}</td>
                                            <td>
                                                @if ($row->is_active)
                                                    <span class="badge bg-success me-1"></span> Active
                                                @else
                                                    <span class="badge bg-danger me-1"></span> InActive
                                                @endif
                                            </td>
                                            
                                            @canany(['items.update', 'items.delete'])
                                            <td class="text-end">
                                                <div class="dropdown">
                                                    <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-start">

                                                        @can('items.update')
                                                        <li>
                                                            <a class="dropdown-item" href="{{ url('/app/items/'.$row->id.'/edit') }}">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon dropdown-item-icon icon-2"><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1"></path><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z"></path><path d="M16 5l3 3"></path></svg>
                                                                Edit
                                                            </a>
                                                        </li>
                                                        @endcan

                                                        @can('items.delete')
                                                        <li>
                                                            <form action="{{ url('/app/items', [$row->id]) }}" method="POST" class="delete_data">
                                                                @csrf @method('DELETE')
                                                                <button class="dropdown-item" type="submit" class="delete">
                                                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  class="icon dropdown-item-icon icon-2"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                                                    Delete
                                                                </button>
                                                            </form>
                                                        </li>
                                                        @endcan

                                                    </ul>
                                                </div>
                                            </td>
                                            @endcanany

                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        
                        {{ $rows->appends(request()->except('page'))->links() }}

                    </div>
                </div>
            </div>
            
        </div>
    </div>


@endsection

