@extends('canteen.layouts.app')

@section('page-title')
Edit Item
@endsection

@section('page.content')

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <div class="col">
                        <h2 class="page-title">
                            Edit Item
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <form action="{{ url('/app/items', [$item->id]) }}" method="post" class="card" id="form">
                        @method('PUT') @csrf
                        <div class="card-body">

                            <div class="row g-5 justify-content-center">
                                <div class="col-lg-6">

                                    <div class="mb-3">
                                        <div class="form-label required">Item Type</div>
                                        <div>

                                            <label class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" value="0" name="has_variant" {{ ($item->has_variant == 0) ? "checked" : "" }} onclick="return false;">
                                                <span class="form-check-label">Non Variant</span>
                                            </label>

                                            <label class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" value="1" name="has_variant" {{ ($item->has_variant == 1) ? "checked" : "" }} onclick="return false;">
                                                <span class="form-check-label">Variant</span>
                                            </label>

                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Name</label>
                                        <div>
                                            <input type="text" name="name" class="form-control" placeholder="Item Name" value="{{ $item->name }}">
                                            <div class="invalid-feedback name_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Description</label>
                                        <div>
                                            <textarea name="description" id="description" class="form-control" cols="30" rows="5" placeholder="Item Description">{{ $item->description }}</textarea>
                                            <div class="invalid-feedback description_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Categories</label>
                                        <div>
                                            <select name="category_ids[]" class="form-control" id="category_ids" multiple>
                                                <option value="">Select Categories</option>
                                                @foreach ($categories as $category)
                                                <option {{ is_array($item->category_ids) && in_array($category->id, $item->category_ids) ? "selected" : "" }} value="{{ $category->id }}">{{ $category->name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="invalid-feedback category_ids_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Price</label>
                                        <div>
                                            <input type="number" name="price" id="price" class="form-control" placeholder="Item Price" value="{{ $item->price }}">
                                            <div class="invalid-feedback price_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Stock Quantity</label>
                                        <div>
                                            <input type="number" name="stock_quantity" class="form-control" placeholder="Item Stock Quantity" value="{{ $item->stock_quantity }}">
                                            <small class="form-hint">For items with unlimited stock, leave the quantity field blank</small>
                                            <div class="invalid-feedback stock_quantity_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Expiry Date {{ $item->expiry_date }}</label>
                                        <div>
                                            <input type="date" id="expiry_date" name="expiry_date" class="form-control" placeholder="Item Stock Quantity" value="{{ $item->expiry_date }}">
                                            <small class="form-hint">If the item does not have an expiry date, leave this field blank.</small>
                                            <div class="invalid-feedback expiry_date_error"></div>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-lg-6">

                                    <div class="mb-3">
                                        <label class="form-label">
                                            Image

                                            @if (!empty($item->image) && file_exists(public_path($item->image)))
                                                <a href="{{ asset( $item->image ) }}" target="_blank" class="ms-2 badge bg-yellow-lt" title="View">View</a>
                                            @endif
                                        
                                        </label>
                                        <div>
                                            <input type="file" name="image" class="form-control" accept="image/*">
                                            <div class="invalid-feedback image_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Ingredients</label>
                                        <div>
                                            <textarea name="ingredients" id="ingredients" class="form-control" cols="30" rows="3" placeholder="Item Ingredients">{{ $item->ingredients }}</textarea>
                                            <div class="invalid-feedback ingredients_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Allergen Info</label>
                                        <div>
                                            <textarea name="allergen_info" id="allergen_info" class="form-control" cols="30" rows="3" placeholder="Item Allergen Information">{{ $item->allergen_info }}</textarea>
                                            <div class="invalid-feedback allergen_info_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Taxes</label>
                                        <div>
                                            <select name="tax_ids[]" class="form-control" id="tax_ids" multiple>
                                                <option value="">Select Taxes</option>
                                                @foreach ($taxes as $tax)
                                                <option {{ is_array($item->tax_ids) && in_array($tax->id, $item->tax_ids) ? "selected" : "" }} value="{{ $tax->id }}">{{ $tax->name }}</option>
                                                @endforeach
                                            </select>
                                            <div class="invalid-feedback tax_ids_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Item Badges</label>
                                        <div>
                                            <select name="badge_ids[]" class="form-control" id="badge_ids" multiple>
                                                <option value="">Select Badges</option>
                                                @foreach ($item_badges as $item_badge)
                                                <option {{ is_array($item->badge_ids) && in_array($item_badge->id, $item->badge_ids) ? "selected" : "" }} value="{{ $item_badge->id }}">{{ $item_badge->name }}</option>
                                                @endforeach
                                            </select>
                                            <small class="form-hint">Choose badges for special characteristics or promotions (e.g., 'Organic', 'Low Cal')</small>
                                            <div class="invalid-feedback badge_ids_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Unit</label>
                                        <div>
                                            <select name="unit_id" class="form-control" id="unit_id">
                                                <option value="">Select Unit</option>
                                                @foreach ($units as $unit)
                                                <option {{ ($item->unit_id == $unit->id) ? "selected" : "" }} value="{{ $unit->id }}">{{ $unit->symbol }}</option>
                                                @endforeach
                                            </select>
                                            <div class="invalid-feedback unit_id_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Position</label>
                                        <div>
                                            <div>
                                                <input type="number" name="position" class="form-control" placeholder="Position" value="{{ $item->position }}">
                                                <small class="form-hint">Enter a number to determine the order of this item. Lower numbers appear first.</small>
                                            </div>
                                            <div class="invalid-feedback position_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Status</label>
                                        <div>
                                            <label class="form-check form-switch form-switch-lg">
                                                <input name="is_active" class="form-check-input" type="checkbox" {{ ($item->is_active == 1) ? "checked" : "" }} value="1">
                                                <span class="form-check-label form-check-label-on">Active</span>
                                                <span class="form-check-label form-check-label-off">InActive</span>
                                            </label>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="row g-5 justify-content-center mb-2" id="variant_item_section" style="display: {{ ($item->has_variant == "1") ? "" : "none" }};">
                                <div class="col-lg-10">

                                    <div class="card" id="item_variants">
                                        <div class="card-header py-2">
                                          <h3 class="card-title">Item Variants</h3>
                                        </div>
                                        <div class="card-body p-0">
                                          <div class="table-responsive">
                                            <table class="table mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            <label class="form-label required mb-0">Variant Name</label>
                                                        </th>
                                                        <th>
                                                            <label class="form-label required mb-0">Price</label>
                                                        </th>
                                                        <th>
                                                            <label class="form-label mb-0">Stock Quantity</label>
                                                        </th>
                                                        <th>
                                                            <label class="form-label mb-0">Expiry Date</label>
                                                        </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="variants_tbody">
                                                    
                                                    @foreach ($item->variants as $vIndex => $item_variant)
                                                        
                                                        <tr class="variant_item">
                                                            <td>
                                                                <input type="hidden" name="variants[{{ $vIndex }}][id]" value="{{ $item_variant->id }}">
                                                                <input type="text" name="variants[{{ $vIndex }}][name]" class="form-control variantsInput" value="{{ $item_variant->name }}">
                                                                <div class="invalid-feedback variants.{{ $vIndex }}.name_error"></div>
                                                            </td>
                                                            <td>
                                                                <input type="number" name="variants[{{ $vIndex }}][price]" class="form-control variantsInput" value="{{ $item_variant->price }}">
                                                                <div class="invalid-feedback variants.{{ $vIndex }}.price_error"></div>
                                                            </td>
                                                            <td>
                                                                <input type="number" name="variants[{{ $vIndex }}][stock_quantity]" class="form-control variantsInput" value="{{ $item_variant->stock_quantity }}">
                                                            </td>
                                                            <td>
                                                                <input type="date" name="variants[{{ $vIndex }}][expiry_date]" class="form-control variantsInput">
                                                                <div class="invalid-feedback variants.{{ $vIndex }}.expiry_date_error"></div>
                                                            </td>
                                                            <td class="text-end">
                                                                <button type="button" class="btn btn-6 btn-danger btn-icon remove_variant" data-bs-toggle="tooltip" title="Remove">
                                                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
                                                                </button>
                                                            </td>
                                                        </tr>

                                                    @endforeach

                                                </tbody>
                                                <tbody>
                                                    <tr>
                                                        <td class="text-end" colspan="7">
                                                            <button type="button" class="btn btn-6 btn-success btn-icon add_variant" data-bs-toggle="tooltip" title="Add New">
                                                                <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                          </div>
                                        </div>
                                      </div>
                                    
                                </div>
                            </div>

                            <div class="row g-5 justify-content-center" id="addon_item_section">
                                <div class="col-lg-10">

                                    <div class="card" id="item_addons">
                                        <div class="card-header py-2">
                                          <h3 class="card-title">Item Addons</h3>
                                        </div>
                                        <div class="card-body p-0">
                                          <div class="table-responsive">
                                            <table class="table mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            <label class="form-label required mb-0">Addon Name</label>
                                                        </th>
                                                        <th>
                                                            <label class="form-label required mb-0">Price</label>
                                                        </th>
                                                        <th style="max-width: 220px;">
                                                            <label class="form-label mb-0">Image</label>
                                                        </th>
                                                        <th style="max-width: 75px;">
                                                            <label class="form-label mb-0">Required</label>
                                                        </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="addons_tbody">

                                                    @foreach ($itemAddons as $aIndex => $itemAddon)
                                                        <tr class="addons_item">
                                                            <td>
                                                                <input type="hidden" name="addons[{{ $aIndex }}][id]" value="{{ $itemAddon->id }}">
                                                                <input type="text" name="addons[{{ $aIndex }}][name]" class="form-control addonInput" value="{{ $itemAddon->name }}">
                                                                <div class="invalid-feedback addons.{{ $aIndex }}.name_error"></div>
                                                            </td>
                                                            <td>
                                                                <input type="number" name="addons[{{ $aIndex }}][price]" class="form-control addonInput" value="{{ $itemAddon->price }}">
                                                                <div class="invalid-feedback addons.{{ $aIndex }}.price_error"></div>
                                                            </td>
                                                            <td style="max-width: 220px;">
                                                                <div class="input-group">
                                                                    <input type="file" name="addons[{{ $aIndex }}][image]" class="form-control addonInput" accept="image/*">
                                                                    @if (!empty($itemAddon->image) && file_exists(public_path($itemAddon->image)))
                                                                        <a class="btn" type="button" href="{{ asset( $itemAddon->image ) }}" data-bs-toggle="tooltip" title="View Image" target="_blank">
                                                                            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-eye me-0"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                                                        </a>
                                                                    @endif
                                                                </div>
                                                                <div class="invalid-feedback addons.{{ $aIndex }}.image_error"></div>
                                                            </td>
                                                            <td class="text-center" style="max-width: 75px;">
                                                                <input class="form-check-input" type="checkbox" name="addons[{{ $aIndex }}][is_required]" {{ ($itemAddon->is_required == 1) ? "checked" : "" }} value="1">
                                                            </td>
                                                            <td class="text-end">
                                                                <button type="button" class="btn btn-6 btn-danger btn-icon remove_addon" data-bs-toggle="tooltip" title="Remove">
                                                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
                                                                </button>
                                                            </td>
                                                        </tr>                                                        
                                                    @endforeach
                                                    
                                                </tbody>
                                                <tbody>
                                                    <tr>
                                                        <td class="text-end" colspan="7">
                                                            <button type="button" class="btn btn-6 btn-success btn-icon add_addon" data-bs-toggle="tooltip" title="Add New">
                                                                <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                          </div>
                                        </div>
                                      </div>
                                    
                                </div>
                            </div>

                            
                        </div>
                        <div class="card-footer text-end">
                            <div class="d-flex">
                                <a href="{{ url('/app/items') }}" class="btn btn-link">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 14l-4 -4l4 -4" /><path d="M5 10h11a4 4 0 1 1 0 8h-1" /></svg>
                                    Cancel
                                </a>
                                <button type="submit" class="btn btn-primary ms-auto">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                                    Save
                                </button>
                            </div>
                        </div>
                    </form>


                </div>
            </div>

        </div>
    </div>


@endsection

@section("page.js")
<script>
    new TomSelect("#category_ids",{});
    new TomSelect("#tax_ids",{});
    new TomSelect("#badge_ids",{});

    $("#form").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#form')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    window.location.href = data.redirect_url;
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){ 
                    $('div.'+prefix.replace(/[^\w-]/g, '\\$&')+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

    $("[name='has_variant']").change(function(){
        if($(this).val() == 1){
            $("#variant_item_section").show();

            $("#price").val(0);
            $("#price").attr("readonly", true);

            $("#stock_quantity").val(null);
            $("#stock_quantity").attr("readonly", true);
        }else{
            $("#variant_item_section").hide();

            $("#price").val(null);
            $("#price").attr("readonly", false);

            $("#stock_quantity").val(null);
            $("#stock_quantity").attr("readonly", false);
        }
    });

    $(document).on("click", ".add_variant", function(){
        $.ajax({
            url: "/app/ajax/items/add-variant-row",
            type: 'GET',
            success: function(res) {
                if(res.success == true){
                    $("#variants_tbody").append(res.data);
                    $('[data-bs-toggle="tooltip"]').tooltip();
                }
            }
        });
    });

    $(document).on("click", ".remove_variant", function(){
    
        Notiflix.Confirm.show(
            'Remove Variant',
            'Are you sure, you want to remove this item variant? Once remove, you cannot restore it again.',
            'Yes',
            'No',
            () => {

                if($("#variants_tbody .variant_item").length <= 2){

                    Notiflix.Report.warning(
                        'Variant Warning',
                        'Variant item should have at least two variants, so that users can make accurate selections and have a complete options experience.',
                        'Okey',
                    );
                    return
                }

                $(this).closest("tr").remove();
            },
            () => {
                return false;
            },
            {
                'messageMaxLength' : 500,
            }
        );
    
    });

    $(document).on("click", ".add_addon", function(){
        $.ajax({
            url: "/app/ajax/items/add-addon-row",
            type: 'GET',
            success: function(res) {
                if(res.success == true){
                    $("#addons_tbody").append(res.data);
                    $('[data-bs-toggle="tooltip"]').tooltip();
                }
            }
        });
    });

    $(document).on("click", ".remove_addon", function(){
    
        Notiflix.Confirm.show(
            'Remove Variant',
            'Are you sure, you want to remove this item addon? Once remove, you cannot restore it again.',
            'Yes',
            'No',
            () => {
                $(this).closest("tr").remove();
            },
            () => {
                return false;
            },
            {
                'messageMaxLength' : 500,
            }
        );
    
    });

</script>
@endsection