<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
        <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title> @yield('page-title') | {{ config('app.name') }}</title>

        <link href="{{ asset('assets/canteen/css/tabler.min.css') }}" rel="stylesheet"/>
        <link rel="stylesheet" href="{{ asset('assets/canteen/css/jquery.passwordRequirements.css') }}">
        <link rel="stylesheet" href="{{ asset('assets/canteen/css/auth_custom.css') }}">
        <!-- CSS files -->
        @yield('page.css')
        
    </head>
    <body class=" d-flex flex-column">

        <div class="page">
            @yield('page.content')
        </div>

		<!-- Libs JS -->
		<script src="{{ asset('assets/canteen/js/jquery-3.7.1.min.js') }}"></script>
        <script src="{{ asset('assets/canteen/js/jquery.passwordRequirements.min.js') }}"></script>
        <script src="{{ asset('assets/canteen/js/notiflix-aio.min.js') }}"></script>
        <script src="{{ asset('assets/canteen/js/auth_custom.js') }}"></script>
        <!-- Tabler Core -->
        <script src="{{ asset('assets/canteen/js/tabler.min.js') }}" defer></script>

        @yield('page.js')
		<script>

			Notiflix.Notify.init({
				clickToClose: true
			});
	
			@if(Session::has('message'))
				Notiflix.Notify.success("{{ session('message') }}");
			@endif
	
			@if(Session::has('error'))
				Notiflix.Notify.failure("{{ session('error') }}");
			@endif
	
			@if(Session::has('info'))
				Notiflix.Notify.info("{{ session('info') }}");
			@endif
	
			@if(Session::has('warning'))
				Notiflix.Notify.warning("{{ session('warning') }}");
			@endif
	
		</script>
    </body>
</html>
