<!doctype html>
<html lang="en">
	<head>
		<meta charset="utf-8"/>
		<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
		<meta http-equiv="X-UA-Compatible" content="ie=edge"/>
		<meta name="csrf-token" content="{{ csrf_token() }}">

		<title> @yield('page-title') | {{ config('app.name') }}</title>
		<!-- CSS files -->
		<link href="{{ asset('assets/canteen/css/tabler.min.css?v=12345') }}" rel="stylesheet"/>
		<link rel="stylesheet" href="{{ asset('assets/canteen/css/jquery.passwordRequirements.css') }}">
		<link rel="stylesheet" href="{{ asset('assets/canteen/css/tom-select.bootstrap5.min.css') }}">
		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/css/intlTelInput.css">
		<link rel="stylesheet" href="{{ asset('assets/canteen/css/app_custom.css') }}">
		<!-- CSS files -->
		@yield('page.css')
	</head>
	<body>
		<div class="page">
			@include('canteen.partials.header')
			<div class="page-wrapper">
				@yield('page.content')
				@include('canteen.partials.footer')
			</div>
		</div>

		@yield('page-modal')

		<!-- Libs JS -->
		<script src="{{ asset('assets/canteen/js/notiflix-aio.min.js') }}"></script>
		<script src="{{ asset('assets/canteen/js/jquery-3.7.1.min.js') }}"></script>
		<!-- Tabler Core -->
		<script src="{{ asset('assets/canteen/js/tabler.min.js') }}" defer></script>
		<script src="{{ asset('assets/canteen/js/theme.min.js') }}" defer></script>

		<!-- Firebase CDN (compat) -->
		<script src="https://www.gstatic.com/firebasejs/12.2.1/firebase-app-compat.js"></script>
		<script src="https://www.gstatic.com/firebasejs/12.2.1/firebase-messaging-compat.js"></script>
		<script src="{{ asset('assets/firebase/fcm-notification.js') }}"></script>

		<script src="{{ asset('assets/canteen/js/jquery.passwordRequirements.min.js') }}"></script>
		<script src="{{ asset('assets/canteen/js/tom-select.complete.min.js') }}"></script>
		<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/js/intlTelInput.min.js"></script>

		<!-- Custom JS -->
		<script src="{{ asset('assets/canteen/js/app_custom.js') }}"></script>
		@yield('page.js')
		<script>

			Notiflix.Notify.init({
				clickToClose: true
			});
	
			@if(Session::has('message'))
				Notiflix.Notify.success("{{ session('message') }}");
			@endif
	
			@if(Session::has('error'))
				Notiflix.Notify.failure("{{ session('error') }}");
			@endif
	
			@if(Session::has('info'))
				Notiflix.Notify.info("{{ session('info') }}");
			@endif
	
			@if(Session::has('warning'))
				Notiflix.Notify.warning("{{ session('warning') }}");
			@endif
	
		</script>
	</body>
</html>
