const PriorityNavScroller = function({
    selector: selector = '.nav-scroller',
    navSelector: navSelector = '.nav-scroller-nav',
    contentSelector: contentSelector = '.nav-scroller-content',
    itemSelector: itemSelector = '.nav-scroller-item',
    buttonLeftSelector: buttonLeftSelector = '.nav-scroller-btn--left',
    buttonRightSelector: buttonRightSelector = '.nav-scroller-btn--right',
    scrollStep: scrollStep = 160
} = {}) {

const navScroller = typeof selector === 'string' ? document.querySelector(selector) : selector;

const validateScrollStep = () => {
    return Number.isInteger(scrollStep) || scrollStep === 'average';
}

if (navScroller === undefined || navScroller === null || !validateScrollStep()) {
    throw new Error('There is something wrong, check your options.');
}

const navScrollerNav = navScroller.querySelector(navSelector);
const navScrollerContent = navScroller.querySelector(contentSelector);
const navScrollerContentItems = navScrollerContent.querySelectorAll(itemSelector);
const navScrollerLeft = navScroller.querySelector(buttonLeftSelector);
const navScrollerRight = navScroller.querySelector(buttonRightSelector);

let scrolling = false;
let scrollAvailableLeft = 0;
let scrollAvailableRight = 0;
let scrollingDirection = '';
let scrollOverflow = '';
let timeout;

document.querySelectorAll('.lock-checkbox').forEach(cb => {
    cb.addEventListener('click', e => e.preventDefault());
});

// Sets overflow and toggle buttons accordingly
const setOverflow = function() {
    scrollOverflow = getOverflow();
    toggleButtons(scrollOverflow);
    calculateScrollStep();
}


// Debounce setting the overflow with requestAnimationFrame
const requestSetOverflow = function() {
    if (timeout) window.cancelAnimationFrame(timeout);

    timeout = window.requestAnimationFrame(() => {
    setOverflow();
    });
}


// Gets the overflow available on the nav scroller
const getOverflow = function() {
    let scrollWidth = navScrollerNav.scrollWidth;
    let scrollViewport = navScrollerNav.clientWidth;
    let scrollLeft = navScrollerNav.scrollLeft;

    scrollAvailableLeft = scrollLeft;
    scrollAvailableRight = scrollWidth - (scrollViewport + scrollLeft);

    // 1 instead of 0 to compensate for number rounding
    let scrollLeftCondition = scrollAvailableLeft > 1;
    let scrollRightCondition = scrollAvailableRight > 1;

    // console.log(scrollWidth, scrollViewport, scrollAvailableLeft, scrollAvailableRight);

    if (scrollLeftCondition && scrollRightCondition) {
    return 'both';
    }
    else if (scrollLeftCondition) {
    return 'left';
    }
    else if (scrollRightCondition) {
    return 'right';
    }
    else {
    return 'none';
    }

}


// Calculates the scroll step based on the width of the scroller and the number of links
const calculateScrollStep = function() {
    if (scrollStep === 'average') {
    let scrollViewportNoPadding = navScrollerNav.scrollWidth - (parseInt(getComputedStyle(navScrollerContent).getPropertyValue('padding-left')) + parseInt(getComputedStyle(navScrollerContent).getPropertyValue('padding-right')));

    let scrollStepAverage = Math.floor(scrollViewportNoPadding / navScrollerContentItems.length);

    scrollStep = scrollStepAverage;
    }
}


// Move the scroller with a transform
const moveScroller = function(direction) {

    if (scrolling === true || (scrollOverflow !== direction && scrollOverflow !== 'both')) return;

    let scrollDistance = scrollStep;
    let scrollAvailable = direction === 'left' ? scrollAvailableLeft : scrollAvailableRight;

    // If there will be less than 25% of the last step visible then scroll to the end
    if (scrollAvailable < (scrollStep * 1.75)) {
    scrollDistance = scrollAvailable;
    }

    if (direction === 'right') {
    scrollDistance *= -1;

    if (scrollAvailable < scrollStep) {
        navScrollerContent.classList.add('snap-align-end');
    }
    }

    navScrollerContent.classList.remove('no-transition');
    navScrollerContent.style.transform = 'translateX(' + scrollDistance + 'px)';

    scrollingDirection = direction;
    scrolling = true;
}


// Set the scroller position and removes transform, called after moveScroller() in the transitionend event
const setScrollerPosition = function() {
    var style = window.getComputedStyle(navScrollerContent, null);
    var transform = style.getPropertyValue('transform');
    var transformValue = Math.abs(parseInt(transform.split(',')[4]) || 0);

    if (scrollingDirection === 'left') {
    transformValue *= -1;
    }

    navScrollerContent.classList.add('no-transition');
    navScrollerContent.style.transform = '';
    navScrollerNav.scrollLeft = navScrollerNav.scrollLeft + transformValue;
    navScrollerContent.classList.remove('no-transition', 'snap-align-end');

    scrolling = false;
}


// Toggle buttons depending on overflow
const toggleButtons = function(overflow) {
    if (overflow === 'both' || overflow === 'left') {
    navScrollerLeft.classList.add('active');
    }
    else {
    navScrollerLeft.classList.remove('active');
    }

    if (overflow === 'both' || overflow === 'right') {
    navScrollerRight.classList.add('active');
    }
    else {
    navScrollerRight.classList.remove('active');
    }
}

const init = function() {

    setOverflow();

    window.addEventListener('resize', () => {
        requestSetOverflow();
    });

    navScrollerNav.addEventListener('scroll', () => {
        requestSetOverflow();
    });

    navScrollerContent.addEventListener('transitionend', () => {
        setScrollerPosition();
    });

    navScrollerLeft.addEventListener('click', () => {
        moveScroller('left');
    });

    navScrollerRight.addEventListener('click', () => {
        moveScroller('right');
    });

};


// Self init
init();


// Reveal API
return {
    init
};

};

const priorityNavScrollerDefault = PriorityNavScroller();

$(document).on("mouseenter", ".allergen-icon", function(e){
    $("#allergen-tooltip").fadeIn(200);
});

$(document).on("mouseleave", ".allergen-icon", function(){
    $("#allergen-tooltip").fadeOut(200);
});

// $(document).on("mousemove", ".allergen-icon", function(e){
//     $("#allergen-tooltip")
//         .css({ top: e.pageY + 10, left: e.pageX + 10 });

//     console.log('Hello');
    

// });

//
$("#newCustomer").click(function(){
    $("#newCustomerModal").modal("show");
});

$(".item-category").click(function(){
    $(".item-category").removeClass('active');
    $(this).addClass('active');
    showCategoryItems($(this).attr('data-catId'));
});

function showCategoryItems(catId){
    $(".pos-item-warp").hide();
    $(".catId-"+catId).show();
}

$("#search_query").on("keyup", function() {

    $(".pos-item-warp").hide();

    let searchQuery = $(this).val().toLowerCase();

    if(searchQuery.length === 0){
        $(".nav-scroller-content .nav-scroller-item").first().click();
        return
    }

    $(".pos-item-warp").filter(function() {
        let itemText = $(this).find(".item-name").text().toLowerCase();
        $(this).toggle(itemText.indexOf(searchQuery) > -1);
    });

});

new TomSelect("#customer_id",{
    allowEmptyOption: true,
});

$('#cart_items_warp').on('change', 'input', function() {
    calculateCart();
});

$(".pos-item").click(function(){
    
    let itemId = $(this).attr("data-itemId");
    
    $.ajax({
        url: "/app/ajax/pos/item-popup/"+itemId,
        type: 'GET',
        success: function(res) {
            if(res.success == true){
                
                $(".pop-up-item-warp").html(res.data.html);

                if($("#cartItemId_"+itemId).length){

                    let cartItemHTML = $("#cartItemId_"+itemId).html();

                    let cartItemId = $(cartItemHTML).find('input[name$="[item_id]"]').val();
                    let cartItemQty = $(cartItemHTML).find('input[name$="[quantity]"]').val();;
                    let cartItemInstructions = $(cartItemHTML).find('textarea[name$="[instructions]"]').val();

                    //Item QTY
                    $("#pop-up-cart-qty").val(cartItemQty)

                    //Item letiant
                    if($(".pop-up-size-item-warp").length){
                        $('input[name="variant_id"][value="'+cartItemId+'"]').prop('checked', true);
                    }                   

                    //Item Instructions
                    $("#instructions").val(cartItemInstructions);                   

                    //Item Addons
                    $(cartItemHTML).find('input[name^="cartItem"][name$="[addon_id]"]').each(function() {

                        let addonId = $(this).val();
                        let addonQty = $(this).closest('tr').find('input[name$="[qty]"]').val();

                        let popupAddon = $('.pop-up-addon[value="'+addonId+'"]');
                        if (popupAddon.length) {
                            popupAddon.prop('checked', true);
                            popupAddon.closest('.col-12').find('.pop-up-addon-cart-qty').val(addonQty);
                        }
                    
                    });

                    popUpTotalCalculate();
                }

                $("#item-modal").modal('show');
            }
        }
    });

});

// Increase
$(document).on('click', '.pop-up-cart-qty-plus', function() {
    let qty = $('#pop-up-cart-qty');
    let current = parseInt(qty.val());
    qty.val(current + 1);
});

// Decrease
$(document).on('click', '.pop-up-cart-qty-minus', function() {
    let qty = $('#pop-up-cart-qty');
    let current = parseInt(qty.val());
    let min = parseInt(qty.attr('min')) || 1;

    if (current > min) {
        qty.val(current - 1);
    };
});

$(document).on('input', '.cart-addon-qty', function() {
    // If value is '0' or empty, set it to 1
    if (this.value === '0' || this.value === '') {
        this.value = 1;
    }
});

$(document).on('input', '#pop-up-cart-qty', function() {
    // If value is '0' or empty, set it to 1
    if (this.value === '0' || this.value === '') {
        this.value = 1;
    }
});

$(document).on('input', '.pop-up-addon-cart-qty', function() {
    // If value is '0' or empty, set it to 1
    if (this.value === '0' || this.value === '') {
        this.value = 1;
    }
});

// Increase
$(document).on('click', '.pop-up-addon-cart-qty-plus', function() {
    let qty =  $(this).siblings('.pop-up-addon-cart-qty');
    let current = parseInt(qty.val());
    qty.val(current + 1);
});

// Decrease
$(document).on('click', '.pop-up-addon-cart-qty-minus', function() {
    let qty =  $(this).siblings('.pop-up-addon-cart-qty');
    let current = parseInt(qty.val());
    let min = parseInt(qty.attr('min')) || 1;

    if (current > min) {
        qty.val(current - 1);
    };
});

$(document).on('click', '.removeCartItem', function() {
    $(this).closest('.crt_item').remove();
    calculateCart();
});

$(document).on('click', '.showAddons', function() {

    let itemId = $(this).attr("data-itemidforaddon");

    let selectedAddonIds = [];
    $("#cart-item-addons-"+itemId).find('.cartItemAddon').each(function() {
        var addOnId = parseFloat($(this).val());
        selectedAddonIds.push(addOnId);
    });
   
    $.ajax({
        url: "/app/ajax/pos/addons-html/"+itemId+'?addonIds='+selectedAddonIds,
        type: 'GET',
        success: function(res) {
            if(res.success == true){
                $("#itemAdons_tbody").html(res.data);
                $("#addonModal").modal("show");
            }
        }
    });

});

$(document).on('click', '#addonsSubmit', function() {

    let addon_ids = $("input[name='itemAddons[]']:checked").map(function() {
        return $(this).val();
    }).get();

    let addonItemId = $("#addon-modal-itemId").val();

    $.ajax({
        url: "/app/ajax/pos/cart-addons-html",
        type: 'POST',
        data: {
            'addon_ids': addon_ids,
        },
        success: function(res) {
            if(res.success == true){
                $("#cart-item-addons-"+addonItemId).html(res.data.html);
                calculateCart();
                $("#addonModal").modal("hide");
            }
        }
    });

});

$("#addCustomerform").submit(function(e) {
    e.preventDefault();
    var form = $(this);
    var url = form.attr('action');
    $.ajax({
        type: "POST",
        url: url,
        processData: false,
        contentType: false,
        data: new FormData($('#addCustomerform')[0]),
        beforeSend: function(){
            $("#customer_id").append(new Option("option text", "value")).change();
        },
        success: function(response){
            if(response.success){

                const customerTom = document.querySelector('#customer_id').tomselect;
                customerTom.addOption({ value: response.data.id, text: response.data.name });
                // customerTom.refreshOptions();
                customerTom.addItem(response.data.id);
                // customerTom.close();

                $("#addCustomerform").trigger("reset");
                $("#newCustomerModal").modal("hide");
            
            }else{
                Notiflix.Notify.failure(data.message);
            }
        },
        error: function(response) {
            $.each(response.responseJSON.errors, function(prefix, val){
                $('div.'+prefix+'_error').text(val[0]);
            })
            $('.error-text').css({'display':'inline'});
            Notiflix.Notify.failure(response.responseJSON.message);
        }
    });
});

$("#form").submit(function(e) {
    e.preventDefault();
    
    if($(".crt_item").length == 0){
        Notiflix.Report.info(
            'Info',
            'Please add at least one item to cart to proceed.',
            'Okay',
        );
        return;
    }
    
    $("#submitOrderPaybleAmount").text(parseFloat($("#payable_amount").text()).toFixed(2));
    $("#submitOrderModal").modal("show");

});

$("#placeOrder").click(function(){

    let restaurant_instruction = $('textarea[name="restaurant_instruction"]').val();

    let paymentMethodId = $('input[name="payment_method_id"]:checked').val();
    let paymentStatusId = $('input[name="payment_status_id"]:checked').val();
    let orderStatusId = $('input[name="order_status_id"]:checked').val();
    let needCutleryValue = $('input[name="need_cutlery"]:checked').val();
    
    if (paymentMethodId === undefined) {
        Notiflix.Notify.failure("Please select a payment method to proceed");
        $('input[name="payment_method_id"]').first().focus();
        return;
    }

    if (paymentStatusId === undefined) {
        Notiflix.Notify.failure("Please select a payment status to proceed");
        $('input[name="payment_status_id"]').first().focus();
        return;
    }

    let formData = new FormData($('#form')[0]);
    formData.append("payment_method_id", paymentMethodId);
    formData.append("restaurant_instruction", restaurant_instruction);
    formData.append("payment_status_id", paymentStatusId);
    formData.append("order_status_id", orderStatusId);
    formData.append("need_cutlery", needCutleryValue);

    var form = $("#form");
    var url = form.attr('action');
    $.ajax({
        type: "POST",
        url: url,
        processData: false,
        contentType: false,
        data: formData,
        beforeSend: function(){
            $(document).find('div.invalid-feedback').text('');
        },
        success: function(data){
            if(data.success){
                if (data.redirect_url) {
                    window.location.href = data.redirect_url;
                }else{
                    $("#order-place-modal-content").html(data.html_response);
                }
            }else{
                Notiflix.Notify.failure(data.message);
            }
        },
        error: function(response) {
            $.each(response.responseJSON.errors, function(prefix, val){
                $('div.'+prefix+'_error').text(val[0]);
            })
            $('.error-text').css({'display':'inline'});
            Notiflix.Notify.failure(response.responseJSON.message);
        }
    });

});

$(document).on('click', '.pop-up-addon-cart-qty-minus', function() {
    popUpTotalCalculate();
});

$(document).on('click', '.pop-up-addon-cart-qty-plus', function() {
    popUpTotalCalculate();
});

$(document).on('click', '.pop-up-cart-qty-minus', function() {
    popUpTotalCalculate();
});

$(document).on('click', '.pop-up-cart-qty-plus', function() {
    popUpTotalCalculate();
});

$(document).on('change', '.pop-up-item-warp', function() {
    popUpTotalCalculate();
});

function popUpTotalCalculate(){

    let itemPrice = 0;
    let itemQty = 1;
    let addonItemsTotal = 0;

    if($(".pop-up-size-item-warp").length){
        let itemVariantId = $('input[name="variant_id"]:checked').val();
        if(!itemVariantId){
            $('input[name="variant_id"]').focus();
            Notiflix.Notify.failure("Kindly choose a size to continue with your selection");
        }
        itemPrice = parseFloat($('input[name="variant_id"]:checked').attr("data-variant-price")) || 0;
    }else{
        itemPrice = parseFloat($("#data-itemPrice").val());
    }

    $('input[name="addon_id[]"]:checked').each(function() {
        let addonPrice = parseFloat($(this).attr("data-addon-price"));
        let qty = parseInt($(this).closest('.col-12').find('.pop-up-addon-cart-qty').val());
        let addonTotal = parseFloat(addonPrice * qty);
        addonItemsTotal += addonTotal;
    });

    itemQty = parseInt($('#pop-up-cart-qty').val());
    let popuTotalAmount = parseFloat((itemPrice * itemQty) + addonItemsTotal);    
    let totalTax = calculateAmountTax(popuTotalAmount, $("#data-itemTaxIds").val(), itemQty);   

    $("#pop-up-addtocart-btn-price").text((popuTotalAmount+totalTax).toFixed(2));

}

$(document).on('click', '.pop-up-addtocart-btn', function() {

    if($(".pop-up-size-item-warp").length){
        let itemVariantId = $('input[name="variant_id"]:checked').val();
        if(!itemVariantId){
            $('input[name="variant_id"]').focus();
            Notiflix.Notify.failure("Kindly choose a size to continue with your selection");
            return;
        }
    }
    let mainItemId = $("#data-itemId").val();
    let itemId = $("#data-itemId").val();
    let itemName = $("#pop-up-item-name").text();
    let itemStockQuantity = $("#data-itemQuantity").val();
    let itemPrice = 0;
    let itemTaxIds = $("#data-itemTaxIds").val();
    let itemAddonsCount = $("#data-addonsCount").val();
    let itemInstructions = $("#instructions").val();
    let itemQty = $("#pop-up-cart-qty").val();
    
    if($(".pop-up-size-item-warp").length){
        itemName = $("#pop-up-item-name").text()+" ("+$('input[name="variant_id"]:checked').attr("data-variant-name")+")";
        itemPrice = parseFloat($('input[name="variant_id"]:checked').attr("data-variant-price")) || 0;
        itemId = $('input[name="variant_id"]:checked').val();
    }else{
        itemPrice = parseFloat($("#data-itemPrice").val());
    }

    let addonHtml = "";
    let addonRows = "";
    $('input[name="addon_id[]"]:checked').each(function(index, element) {
        let addonId = $(this).val();
        let addonName = $(this).attr("data-addon-name");
        let addonPrice = parseFloat($(this).attr("data-addon-price"));
        let addonQty = parseInt($(this).closest('.col-12').find('.pop-up-addon-cart-qty').val());

        addonRows += '<tr class="cart-addon-tr"><td>'+addonName+'<br>'+currency+' '+addonPrice+'<input type="hidden" class="cartItemAddon" data-addonPrice="'+addonPrice+'" name="cartItem['+itemId+'][addons]['+index+'][addon_id]" value="'+addonId+'"></td><td style="width: 110px;"><div class="input-icon"><span class="input-icon-addon"><div class="text-secondary" role="status">QTY</div></span><input type="text" class="form-control cart-addon-qty text-center" name="cartItem['+itemId+'][addons]['+index+'][qty]" value="'+addonQty+'"></div></td></tr>';
    });

    if($('input[name="addon_id[]"]:checked').length){
        addonHtml = '<table style="width: 100%;" class="table table-sm table-bordered text-dark fw-bold"><thead><tr class="bg-lime-lt"><td colspan="2">Addons</td></tr></thead><tbody>'+addonRows+'</tbody></table>';
    }

    let cartElement = '<div data-itemTaxIds="'+itemTaxIds+'" class="accordion-item crt_item" id="cartItemId_'+mainItemId+'"><button class="accordion-header pos-accordion-header collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-'+itemId+'-inverted" aria-expanded="false"><div class="accordion-header-text pos-accordion-header-text"><table style="width: 100%"><tr><th class="pe-1">'+itemName+' <input type="hidden" name="cartItem['+itemId+'][item_id]" value="'+itemId+'"><input type="hidden" class="item_price" value="'+itemPrice+'"></th><th style="width: 110px; text-align:right;"><span>'+currency+'</span> <span class="item_subtotal">'+itemPrice+'</span></th><th style="width: 30px; text-align:right;"><span class="removeCartItem"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor" class="me-0 icon icon-tabler icons-tabler-filled icon-tabler-xbox-x text-danger"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 2c5.523 0 10 4.477 10 10s-4.477 10 -10 10s-10 -4.477 -10 -10s4.477 -10 10 -10m3.6 5.2a1 1 0 0 0 -1.4 .2l-2.2 2.933l-2.2 -2.933a1 1 0 1 0 -1.6 1.2l2.55 3.4l-2.55 3.4a1 1 0 1 0 1.6 1.2l2.2 -2.933l2.2 2.933a1 1 0 0 0 1.6 -1.2l-2.55 -3.4l2.55 -3.4a1 1 0 0 0 -.2 -1.4" /></svg></span></th></tr></table></div><div class="accordion-header-toggle"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-1"><path d="M6 9l6 6l6 -6"></path></svg></div></button><div id="collapse-'+itemId+'-inverted" class="accordion-collapse collapse" data-bs-parent="#accordion-inverted" style=""><div class="accordion-body ms-4 px-1"><div class="cart-item-addon-warp" id="cart-item-addons-'+itemId+'">'+addonHtml+'</div><table style="width: 100%"><tr><td class="pe-2"><label class="form-label required mb-1">Item Quantity</label><input type="number" class="form-control item_qty" id="cartItemQty_'+itemId+'" name="cartItem['+itemId+'][quantity]" value="'+itemQty+'" min="1"></td><td class="ps-2"><label class="form-label mb-1">Discount (BDT)</label><input type="number" value="0" class="form-control item_discount" id="cartItemDiscount_'+itemId+'" name="cartItem['+itemId+'][discount]" placeholder="Discount Amount"></td><td>&ensp;&ensp;&ensp;&ensp;</td></tr><tr><td colspan="2"><label class="form-label mb-1 mt-2">Special Instructions</label><textarea class="form-control" id="cartItemInstructions_'+itemId+'" name="cartItem['+itemId+'][instructions]" rows="1">'+itemInstructions+'</textarea></td></tr></table></div></div></div>';
    

    if($("#cartItemId_"+mainItemId).length){
        $("#cartItemId_"+mainItemId).replaceWith(cartElement);
    }else{
        $("#accordion-inverted").append(cartElement);
        $('#cart_items_warp').scrollTop($('#cart_items_warp')[0].scrollHeight);
    }
    $("#item-modal").modal("hide");

    calculateCart();
});


function calculateCart() {

    let subtotal = 0;
    let discount = 0;
    let total_tax = 0;
    let net_amount = 0;
    let payable_amount = 0;
    
    $('.crt_item').each(function(index, element) {
        
        let cartItemPrice = parseFloat($(element).find('.item_price').val());
        let totalAddonItemPrice = 0;        

        $(element).find('.cart-addon-tr').each(function(index, el) {
            let price = parseFloat($(el).find('.cartItemAddon').data('addonprice')) || 0;
            let qty = parseInt($(el).find('.cart-addon-qty').val()) || 0;
            totalAddonItemPrice += (price * qty);
        });

        let cartItemQty = parseInt($(element).find('.item_qty').val());
        let cartItemDiscount = parseFloat($(element).find('.item_discount').val());
        let cartItemTotalBeforeDiscount = (cartItemPrice * cartItemQty) + totalAddonItemPrice;
        let cartItemTotalAfterDiscount = (cartItemTotalBeforeDiscount - cartItemDiscount);
        let cartITemTaxIds = $(this).attr("data-itemTaxIds");
        let cartItemTotalTax = calculateAmountTax(cartItemTotalAfterDiscount, cartITemTaxIds, cartItemQty);
        let cartItemSubTotal = ((cartItemTotalTax + cartItemTotalAfterDiscount));

        subtotal += cartItemTotalBeforeDiscount;
        discount += cartItemDiscount;
        net_amount += cartItemTotalAfterDiscount;
        total_tax += parseFloat(cartItemTotalTax);
        payable_amount += cartItemSubTotal;
        
        $(element).find('.item_subtotal').text(cartItemTotalAfterDiscount.toFixed(2));
        
    });

    $("#subtotal").text(subtotal.toFixed(2));
    $("#discount").text(discount.toFixed(2));
    $("#net_amount").text(net_amount.toFixed(2));
    $("#total_tax").text(total_tax.toFixed(2));
    $("#payable_amount").text(payable_amount.toFixed(2));

}

function calculateAmountTax(amount, taxIds, qty) {

    let taxAmount = 0;
    JSON.parse(taxIds).forEach(taxId => {
        let taxObj = taxesCollection[taxId];

        if(taxObj.type == "percentage"){
            taxAmount += (amount * parseFloat(taxObj.value)) / 100;
        }else{
            taxAmount += parseFloat(taxObj.value) * qty;
        }
    });
    
    return taxAmount;
    
}