
$(document).ready(function() {

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ajaxStart(function () {    
        Notiflix.Loading.dots('Processing your request...');
    });

    $(document).ajaxComplete(function (event, xhr, options) {    
        Notiflix.Loading.remove(600);
    })

    $('.pr-password').passwordRequirements();

    document.querySelectorAll('.password_toggle').forEach(function (button) {
        button.addEventListener('click', function () {
            // Find the password input field
            const inputGroup = this.closest('.input-group');
            const password = inputGroup.querySelector('.form-control');

            // Toggle the password field type
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);

            // Toggle the visibility of show/hide icons
            const showIcon = this.querySelector('.password_show');
            const hideIcon = this.querySelector('.password_hide');

            showIcon.classList.toggle('d-none');
            hideIcon.classList.toggle('d-none');
        });
    });


});
