document.querySelector('.hide-theme-dark').addEventListener('click', function() {
    localStorage.setItem("appTheme", "dark");
    document.body.setAttribute("data-bs-theme", "dark");
});
document.querySelector('.hide-theme-light').addEventListener('click', function() {
    localStorage.setItem("appTheme", "light");
    document.body.removeAttribute("data-bs-theme");
});

$(document).ready(function() {

    $('.pr-password').passwordRequirements();

    document.querySelectorAll('.password_toggle').forEach(function (button) {

        button.addEventListener('click', function () {

            // Find the password input field
            const inputGroup = this.closest('.input-group');
            const password = inputGroup.querySelector('.form-control');

            // Toggle the password field type
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);

            // Toggle the visibility of show/hide icons
            const showIcon = this.querySelector('.password_show');
            const hideIcon = this.querySelector('.password_hide');

            showIcon.classList.toggle('d-none');
            hideIcon.classList.toggle('d-none');
        });
    });

    $(document).on("click", ".remove-file", function(){

        let tableName = $(this).attr("data-table-name");
        let rowId =  $(this).attr("data-row-id");
        let columnName =  $(this).attr("data-column-name");
    
        Notiflix.Confirm.show(
            'Delete File',
            'Are you sure, you want to delete this file? Once deleted, you cannot restore it again.',
            'Yes',
            'No',
            () => {
    
                $.ajax({
                    url: '/file/delete',
                    method: 'POST',
                    data: {
                        table: tableName,
                        rowId: rowId,
                        column: columnName,
                    },
                    success: function(response) {
                        $('#'+columnName+'_show').hide();
                        $('#'+columnName+'_remove').hide();
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(jqXHR, textStatus, errorThrown);
                    }
                });
    
            },
            () => {
                return false;
            },
            {
                'messageMaxLength' : 500,
            }
        );
    
    });
    
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ajaxStart(function () {    
        Notiflix.Loading.dots('Processing your request...');
    });
    
    $(document).ajaxComplete(function (event, xhr, options) {    
        Notiflix.Loading.remove(600);
    })
    
    $(document).on("submit", ".delete_data", function (e) {
    
        e.preventDefault();
        var form = $(this);
        var formURL = form.attr('action');
        var formData = form.serialize();
        var confirmUrl = formURL+'/delete';
        
        $.ajax({
            url: confirmUrl,
            type: 'GET',
            dataType: 'json',
            success: function (res) {

                if (res.deletion_allowed == true) {

                    Notiflix.Confirm.show(
                        'Delete Record',
                        'Are you sure, you want to delete this record? Once deleted, you cannot restore it again.',
                        'Yes',
                        'No',
                        () => {
                            doDelete(formURL, formData);
                        },
                        () => {
                            return false;
                        },
                        {
                            'messageMaxLength' : 500,
                        }
                    );
                
                }else{

                    Notiflix.Report.info(
                        'Record Deletion Not Allowed',
                        '"Knowledge rests not upon truth alone, but upon error also." <br/><br/>- Carl Gustav Jung',
                        'Okay',
                    );
                
                }
            
            }
        });
    
        function doDelete(url, formData) {
            $.ajax({
                url: url,
                type: 'POST',
                dataType: 'json',
                data: formData,
                success: function (res) {
                    window.location.reload();
                }
            });
        }

    });

    if($("#mobile_number").length){

        const input = document.querySelector("#mobile_number");

        window.intlTelInput(input, {
            nationalMode: false,
            formatOnDisplay: true,
            separateDialCode: false,
            autoHideDialCode: false,
            initialCountry: "bd",
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/js/utils.js",
        });

        // Watch for input change
        input.addEventListener('blur', function () {
        const currentNumber = input.value.trim();
        const dialCode = '+' + iti.getSelectedCountryData().dialCode;

        // If user deletes the dial code or types an invalid number
        if (!currentNumber.startsWith(dialCode)) {
            // Re-insert full number in correct format
            const national = currentNumber.replace(/\D/g, ''); // keep digits only
            const formatted = iti.getNumber(); // best effort (uses internal formatting)
            
            if (formatted) {
                input.value = formatted;
            } else {
                input.value = dialCode; // fallback: just show dial code
            }
        }
        });

        var iti = window.intlTelInput.getInstance(input);
        input.addEventListener('input', function() {
            $("#mobile_code").val('+'+iti.getSelectedCountryData().dialCode)
        });
    
    }

    // flatpickr("input[type=datetime-local]", {
    //     enableTime: true,
    //     dateFormat: "Y-m-d H:i",
    //     altInput: true,
    //     altFormat: "d-M-Y h:i K",
    // });
    
    // flatpickr("input[type=date]", {
    //     dateFormat: "Y-m-d",
    //     altInput: true,
    //     altFormat: "d-M-Y",
    //     // defaultDate: todayDate,
    // });
    
    // flatpickr("input[type=time]", {
    //     enableTime: true,
    //     noCalendar: true,
    //     dateFormat: "H:i",
    //     time_24hr: true
    // });

});
