<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create the trigger
        DB::statement('
            CREATE TRIGGER create_users_uid
            BEFORE INSERT ON users
            FOR EACH ROW
            BEGIN
                DECLARE last_uid INT;
                SET last_uid = (
                    SELECT COALESCE(MAX(uid), 0)
                    FROM users
                    WHERE main_id = NEW.main_id
                );
                SET NEW.uid = last_uid + 1;
            END
        ');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Schema::dropIfExists('trigger_insert_users_uid');
    }
};
