<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_item_taxes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id');
            $table->unsignedBigInteger('tax_id');
            $table->unsignedBigInteger('order_item_id');
            $table->string('tax_name', 100);
            $table->enum('tax_type', ['percentage', 'fixed']);
            $table->decimal('tax_value', 8,2);
            $table->decimal('item_tax_amount', 8,2);
            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
            // $table->foreign('tax_id')->references('id')->on('taxes')->onDelete('cascade');
            $table->foreign('order_item_id')->references('id')->on('order_items')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_item_taxes');
    }
};
