<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create the trigger
        DB::statement('
            CREATE TRIGGER create_orders_uid
            BEFORE INSERT ON orders
            FOR EACH ROW
            BEGIN
                DECLARE last_uid INT;
                SET last_uid = (
                    SELECT COALESCE(MAX(uid), 0)
                    FROM orders
                    WHERE user_main_id = NEW.user_main_id
                );
                SET NEW.uid = last_uid + 1;
            END
        ');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
