<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('item_addons', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_main_id')->unsigned();
            $table->bigInteger('item_id')->unsigned();

            $table->string('name', 100);
            $table->decimal('price');

            $table->string('image', 255)->nullable();
            $table->boolean('is_required')->default(0);

            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('item_id')->references('id')->on('items')->onDelete('cascade');
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('item_addons');
    }
};
