<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('uid')->unsigned();
            $table->bigInteger('user_main_id')->unsigned();
            
            $table->string('name', 100);
            $table->string('email');
            $table->string('mobile_number', 16);
            $table->string('password');

            $table->string('address')->nullable();

            $table->string('otp', 6)->nullable();
            $table->timestamp('otp_expired_at')->nullable();
            $table->boolean('is_verified')->default(0);
            $table->timestamp('otp_verified_at')->nullable();

            $table->string('timezone', 32)->default('Asia/Dhaka');
            $table->string('country', 2);

            $table->string('type', 32)->default('customer');

            $table->timestamp('last_login_at')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('employee_id')->references('id')->on('users')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
