<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('uid')->unsigned();
            $table->string('name');
            $table->string('user_name');
            $table->string('email')->nullable();
            $table->string('mobile_number', 16);
            $table->string('password');

            $table->string('otp', 6)->nullable();
            $table->timestamp('otp_expired_at')->nullable();
            $table->boolean('is_verified')->default(0);
            $table->timestamp('otp_verified_at')->nullable();

            $table->boolean('is_active')->default(1);

            $table->string('timezone', 32)->default('Asia/Dhaka');
            $table->string('country', 2);

            $table->timestamp('last_login_at')->nullable();

            $table->string('business_name', 100)->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->bigInteger('main_id')->unsigned()->nullable();
            $table->string('currency', 3)->default('BDT');

            $table->string('type', 21)->default('canteen');

            $table->string('designation', 52)->default('admin');

            $table->text('fcm_token')->nullable();

            // Add index
            $table->index('main_id');
            $table->foreign('main_id')->references('id')->on('users')->onDelete('cascade');

        });

        // Schema::create('password_reset_tokens', function (Blueprint $table) {
        //     $table->string('email')->primary();
        //     $table->string('token');
        //     $table->timestamp('created_at')->nullable();
        // });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
