<?php

namespace App\Traits;

use App\Models\OrderPayment;
use Illuminate\Support\Facades\Auth;

trait InsertOrderPayment
{
    public function iop_insert_payment($order, $transactionId = null){

        $payment = new OrderPayment();
        $payment->user_main_id = $order->user_main_id;
        $payment->order_id = $order->id;

        if(Auth::check() && auth()->user()->getTable() == "users"){
            $payment->payment_accepted_by = auth()->user()->id;
        }

        $payment->amount = $order->payable_amount;
        $payment->currency = $order->currency;
        $payment->payment_method_id = $order->payment_method_id;
        $payment->status = "paid";
        $payment->transaction_id = $transactionId;
        $payment->save();

    }
}
