<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Kyslik\ColumnSortable\Sortable;
use Spatie\Permission\Traits\HasPermissions;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use SoftDeletes, Notifiable, Sortable, HasPermissions, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $sortable = [
        'id',
        'uid',
        'name',
        'user_name',
        'email',
        'mobile_number',
        'otp_expired_at',
        'is_verified',
        'otp_verified_at',
        'is_active',
        'timezone',
        'country',
        'type',
        'designation',
        'last_login_at',
        'created_at',
        'updated_at',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'designation',
        'name',
        'user_name',
        'email',
        'mobile_number',
        'password',
        'otp',
        'otp_expired_at',
        'is_verified',
        'otp_verified_at',
        'is_active',
        'timezone',
        'country',
        'last_login_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'otp_expired_at' => 'datetime',
            'otp_verified_at' => 'datetime',
            'last_login_at' => 'datetime',
            'password' => 'hashed',
            'pos_payment_methods_ids' => 'array',
            'web_payment_methods_ids' => 'array',
        ];
    }

    public function subscription(){
        return $this->hasOne('App\Models\MembershipSubscription', 'user_main_id')->latestOfMany();
    }

    public function order_payments(){
        return $this->hasMany('App\Models\OrderPayment', 'user_main_id');
    }

    public function accepted_order_payments(){
        return $this->hasMany('App\Models\OrderPayment', 'payment_accepted_by');
    }

}
