<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kyslik\ColumnSortable\Sortable;

class OrderPayment extends Model
{
    use SoftDeletes, Sortable;

    public function user(){
        return $this->belongsTo('App\Models\User', 'user_main_id');
    }

    public function accepted_by(){
        return $this->belongsTo('App\Models\User', 'payment_accepted_by');
    }

    public function order(){
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

    public $sortable = [
        'id',
        'uid',
        'user_main_id',
        'order_id',
        'payment_accepted_by',
        'amount',
        'currency',
        'payment_method_id',
        'status',
        'transaction_id',
        'created_at',
        'updated_at'
    ]; 

}
