<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kyslik\ColumnSortable\Sortable;

class OrderItem extends Model
{
    use SoftDeletes, Sortable;

    public $sortable = [
        'id',
        'created_at',
        'updated_at'
    ];

    protected $fillable = [
        'order_id',
        'item_id'
    ];

    public function item_addons()
    {
        return $this->hasMany('App\Models\OrderItemAddon', 'order_item_id');
    }

    public function item_taxes()
    {
        return $this->hasMany('App\Models\OrderItemTax', 'order_item_id');
    }

    public function main_item_addon()
    {
        return $this->hasMany('App\Models\ItemAddon', 'item_id', 'item_id');
    }

    public function item()
    {
        return $this->belongsTo('App\Models\Item', 'item_id');
    }
    
}
