<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kyslik\ColumnSortable\Sortable;

class Item extends Model
{
    use SoftDeletes, Sortable;
    use \Staudenmeir\EloquentJsonRelations\HasJsonRelationships;

    public function user(){
        return $this->belongsTo('app\Models\User', 'user_main_id');
    }
    
    protected $fillable = [
        'user_main_id',
        'name',
        'is_active',
    ];

    public $sortable = [
        'id',
        'uid',
        'has_variant',
        'name',
        'price',
        'stock_quantity',
        'position',
        'is_active',
        'created_at',
        'updated_at'
    ];

    protected function casts(): array
    {
        return [
            'category_ids' => 'array',
            'tax_ids' => 'array',
            'badge_ids' => 'array',
        ];
    }

    public function main_item(){
        return $this->belongsTo('App\Models\Item', 'item_id');
    }

    public function variants(){
        return $this->hasMany('App\Models\Item', 'item_id');
    }

    public function addons(){
        return $this->hasMany('App\Models\ItemAddon', 'item_id');
    }

    public function categories(){
        return $this->belongsToJson('App\Models\Category', 'category_ids');
    }

    public function taxes(){
        return $this->belongsToJson('App\Models\Tax', 'tax_ids')->orderBy('position', 'asc');
    }

    public function badges(){
        return $this->belongsToJson('App\Models\ItemBadge', 'tax_ids')->orderBy('position', 'asc');
    }

}
