<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Kyslik\ColumnSortable\Sortable;

class Customer extends Authenticatable
{
    use SoftDeletes, Notifiable, Sortable;

    protected $sortable = [
        'name',
        'email',
        'mobile_number',
        'otp_expired_at',
        'is_verified',
        'otp_verified_at',
        'is_active',
        'timezone',
        'country',
        'last_login_at',
        'created_at',
        'updated_at',
    ];

    protected $fillable = [
        'user_main_id',
        'name',
        'email',
        'mobile_number',
        'password',
        'otp',
        'otp_expired_at',
        'is_verified',
        'otp_verified_at',
        'timezone',
        'country',
        'last_login_at',
    ];

    protected function casts(): array
    {
        return [
            'otp_expired_at' => 'datetime',
            'otp_verified_at' => 'datetime',
            'last_login_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function employee(){
        return $this->belongsTo('App\Models\User', 'employee_id');
    }

}
