<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetAppDomain
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $parts = explode('.', request()->getHost());

        if(count($parts) === 3){

            $business = User::selectRaw('id,business_name,user_name,logo')->where('user_name', $parts[0])->firstOrFail();

            config()->set('app.url', $request->getSchemeAndHttpHost());
            config()->set('app.business_name', $business->business_name);
            config()->set('app.business_id', $business->main_id);
            config()->set('app.logo', $business->logo);

        }

        return $next($request);
    }
}
