<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfNotAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $parts = explode('.', request()->getHost());

        if(count($parts) === 3){

            if(Auth::guest()){
                
                // Prevent redirect loop if the user is already on the login page
                if (($request->is('app') || $request->is('app/*')) && !$request->is('app/login')) {
                    return redirect('app/login');
                }
            }
        
        }


        return $next($request);
    }
}
