<?php

namespace App\Http\Controllers\CANTEEN;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    public function index(){

        $employees = User::select('id', 'name', 'type', 'designation')->where('type', 'employee')
            ->where('main_id', auth()->user()->main_id)
            ->get();
        
        return view('canteen.pages.permissions.index', compact('employees'));
    }

    public function syncPermission(Request $request){

        if($request->action == "give"){

            $user = User::find($request->userId);
            $permission = Permission::find($request->permission_id);
            $user->givePermissionTo($permission);

            return response()->json([
                'success' => true,
                'message' => 'Permissions successfully added',
            ]);
        }

        if($request->action == "revoke"){

            $user = User::find($request->userId);
            $permission = Permission::find($request->permission_id);
            $user->revokePermissionTo($permission);

            return response()->json([
                'success' => true,
                'message' => 'Permissions successfully removed',
            ]);
        }


    }

}
