<?php

namespace App\Http\Controllers\CANTEEN;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function loginForm(string $subdomain){
        $canteen = User::where('user_name', $subdomain)->first();
        return view('canteen.auth.login', compact('canteen'));
    }

    public function loginPost(Request $request){

        $request->validate([
            'email' => ['required', 'email', 'max:200'],
            'password' => ['required', 'string']
        ]);

        if(Auth::attempt($request->only('email', 'password'))){

            $request->session()->regenerate();
            $user = User::find(auth()->user()->id);

            if($user->is_active == 0){
                auth()->logout();
                $request->session()->invalidate();
                $request->session()->regenerateToken();
                return response()->json([
                    'success' => false,
                    'message' => "Your account is not active, please contact support."
                ]);
            }

            $user->last_login_at = Carbon::now()->toDateTimeLocalString();
            $user->save();

            return response()->json([
                'success' => true,
                'redirect_url' => url('/app'),
            ]);

        }

        return response()->json([
            'success' => false,
            'message' => "These credentials do not match our records."
        ]);
        
    }

    public function logout(Request $request){

        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/app');
    }

    public function registrationForm(string $subdomain){

    }

}
