<?php

namespace App\Http\Controllers\CANTEEN;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\Item;
use App\Models\ItemAddon;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;

class AjaxResponseController extends Controller
{
    public function addVariantRow(){

        return response()->json([
            'success' => true,
            'data' => view('canteen.pages.items.variantRow')->render(),
        ]);
    
    }

    public function addAddonRow(){
        
        return response()->json([
            'success' => true,
            'data' => view('canteen.pages.items.addonRow')->render(),
        ]);

    }

    public function createCustomer(Request $request){

        $request->merge(['mobile_number' => str_replace([' ', '-'],'', $request->mobile_code.$request->mobile_number)]);

        //
        $request->validate([
            'name' => ['required', 'max:100'],
            'email' => ['nullable', 'email:rfc,dns', 'max:100'],
            'mobile_number' => ['required', Rule::unique('customers')->where(function ($query){
                return $query->where('user_main_id', auth()->user()->main_id)
                    ->whereNull('deleted_at');          
            })],
            'address' => ['nullable', 'max:120'],
        ]);

        $password = "Pass@". rand(1000, 9999);

        $customer = new Customer();
        $customer->user_main_id = auth()->user()->main_id;

        $customer->name = $request->name;
        $customer->email = $request->email;
        $customer->mobile_number = $request->mobile_number;
        $customer->address = $request->address;

        $customer->otp_verified_at = Carbon::now()->toDateString();
        $customer->password = Hash::make($password);
        $customer->is_verified = 1;
        $customer->country = "BD";

        $customer->save();

        return response()->json([
            'success' => true,
            // 'data' => '<option value="'.$customer->id.'">'.$customer->name.'</option>',
            'data' => $customer,
        ]);


    }

    public function addonsHtml(Request $request, string $subdomain, string $itemId){

        $selectedAddonIds = explode(',', $request->addonIds);

        $item = Item::findOrFail($itemId);
        if(!empty($item->item_id)){
            $item = Item::findOrFail($item->item_id);
        }

        $addons = ItemAddon::where('item_id', $item->id)->get();

        return response()->json([
            'success' => true,
            'data' => view('canteen.pages.pos.itemAddons', compact('item', 'addons', 'selectedAddonIds'))->render(),
        ]);

    }

    public function cartAddonsHtml(Request $request){

        if(!is_array($request->addon_ids) || count($request->addon_ids) == 0){
            return response()->json([
                'success' => true,
                'data' => [
                    'html' => null,
                ]
            ]);
        }

        $addons = ItemAddon::find($request->addon_ids);
        $item = Item::find($addons->first()->item_id);

        return response()->json([
            'success' => true,
            'data' => [
                'html' => view('canteen.pages.pos.carItemAddons', compact('item', 'addons'))->render(),
            ]
        ]);

    }

    public function userPermissions(string $subdomain, string $userId){

        $user = User::find($userId);

        return response()->json([
            'success' => true,
            'data' => $user->permissions->pluck('id')->toArray(),
        ]);

    }

    public function cartItemPopUp(string $subdomain, $itemId){

        $item = Item::with('variants', 'addons', 'taxes', 'badges')->find($itemId);
        $item->addon_count = 0;
        if(!empty($item->item_id)){
            $item['addon_count'] = ItemAddon::where('item_id', $item->item_id)->count();
        }else{
            $item['addon_count'] = ItemAddon::where('item_id', $item->id)->count();
        }

        return response()->json([
            'success' => true,
            'data' => [
                'html' => view('canteen.pages.pos.carItemPopUp', compact('item'))->render(),
            ]
        ]);

    }


}
